// Various defs for IR program

// Defs for main menu
char *const MAINT = " OPTIONS ";
char *const MAIN1 = "  Record IR Signals  ";
char *const MAIN2 = " Playback IR Signals ";
char *const MAIN3 = "  Find Tape Signals  ";
char *const MAINQ = "   - EXIT PROGRAM -  ";

// Defs for IR Signal Recording menu
char *const RECTITLE = " IR Signal Recording Menu ";
char *const RECCD    = " CD ";
char *const RECTAPE  = " Tape ";
char *const RECAMP   = " Amplifier ";
char *const RECSAT   = " Sat Receiver ";
char *const RECVIDEO = " Video ";
char *const RECTV    = " TV ";
char *const RECCAM   = " Camcorder ";
char *const RECCOMP  = " Computer ";
char *const RECQUIT  = " QUIT RECORD MENU ";

// Defs for IR Signal Playback menu
char *const PLAYTITLE = " IR Signal Playback Menu ";
char *const PLAYREP =   " Repeat signal playback [ ]";
char *const PLAYQUIT  = " QUIT PLAYBACK MENU ";
extern char PTITLE[40];

// Menu position defs
#define MENUX  14           // X position of menu
#define MENUW  30           // Menu width
#define MENUY  4            // Y position of menu
#define MENUH  12           // Menu height

// -- C Function prototypes --
void   CalcData(int, int, int);
void   CalcSignal(int, int, int);
void   ClearSignalArray();
void   DoRecord();
void   DoPlayback(int);
void   DrawRes(int, int, int);
int    FindTapeIR();
void   GraphErr(int);
void   Info();
int    InitGraph();
void   MainMenu();
int    PlayAMP();
int    PlayCAM();
int    PlayCD();
int    PlaybackMenu();
int    PlaySAT();
int    PlayTAPE();
int    PlayTV();
int    PlayVIDEO();
void   PrintDataStr(int, int, int);
void   PrintInst(int);
void   PrintMsg(char*);
void   PrintParams(int, int, int);
void   Printxy(int, int, char*);
int    QuitMenu();
int    QuitProgram();
int    ReadData(char*);
int    RecordAMP();
int    RecordCAM();
int    RecordCD();
int    RecordCOMP();
int    RecordMenu();
int    RecordSAT();
int    RecordTAPE();
int    RecordTV();
int    RecordVIDEO();
int    RepeatPlay();
int    SaveData(char*);
void   SetTextScreen();
void   TextBox(int, int, int, int);
